#include <p30fxxxx.h>
#include <timer.h>

/********************************************************************
*    Function Name:  OpenTimer2                                     *
*    Description:    This routine configures the timer control regis*
*                    ter and timer period register.                 *
*    Parameters:     config: bit definitions to configure Timer2    *
*                    period: value to be loaded to PR reg           *
*    Return Value:   None                                           *
********************************************************************/

void OpenTimer2(unsigned int config,unsigned int period)
{
    TMR2  = 0;          /* Reset Timer2 to 0x0000 */
    PR2   = period;     /* assigning Period to Timer period register */
    T2CON = config;     /* configure control reg */
    T2CONbits.T32 = 0;
}
